
!"Pocket Smalltalk fileout - Sunday, March 18, 2001-9:38:41 AM"!


!Integer methodsFor: 'benchmarking'!

benchFib
	"
	Handy message send-heavy benchmark"


	self < 2 ifTrue: [^1].
	^(self - 1) benchFib + (self - 2) benchFib + 1! !


!Integer methodsFor: 'benchmarking'!

benchmark
	"
	Handy bytecode-heavy benchmark"

    | size flags prime k count |
    size := 1024.   "scaled down by j.clonts from 8190"

    1 to: self do:
        [:iter |
        count := 0.
  
        flags := Array new: size. 
        flags atAllPut: true.  "note atAllPut: returns element"
        1 to: size do:
            [:i | 
            (flags at: i) ifTrue:
                [prime := i+1.
                k := i + prime.
                [k <= size] whileTrue:
                    [flags at: k put: false.
                    k := k + prime].
                count := count + 1]]].
    ^ count! !


!Integer methodsFor: 'benchmarking'!

tinyBenchmarks
	"
	Report the results of running the two tiny Squeak benchmarks."
	"0 tinyBenchmarks"

	| t1 t2 r n1 n2 beg|
	n1 := 1.
	[t1 := Time milliSecondsToRun: [n1 benchmark].
	t1 < 1000] whileTrue:[n1 := n1 * 2]. 
	"Note: #benchmark's runtime is about O(n)"

	n2 := 10.
	[t2 := Time milliSecondsToRun: [r := n2 benchFib].
	t2 < 1000] whileTrue:[n2 := n2 + 1]. 
	"Note: #benchFib's runtime is about O(k^n),
		where k is the golden number = (1 + 5 sqrt) / 2 = 
1.618...."

    "j.clonts note: scaled from 500000 downto 62500 for Pocketsmalltalk/Palm"
	^ ((n1 * 62500 * 1000) // t1) printString, ' bytecodes/sec; ', 
	  ((r * 1000) // t2) printString, ' sends/sec'! !


!Time class methodsFor: 'timing'!

millisecondsToRun: block
	"	^	<Integer>
	Return the number of milliseconds to run block.  Keep in mind that we
	are using the Palm ticks function and that this measure may not be very
	precise."
	
	| start |
	start := SYSTRAP TimGetTicks.
	block value.
	^SYSTRAP TimGetTicks- start "* 1000 // SYSTRAP SysTicksPerSecond"! !


